/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.util.BcWords;
import ext.lib.poi.PoiConstants;
import ext.lib.poi.PoiExportCondition;
import ext.lib.poi.PoiUtil;
import ext.lib.poi.PoiWords;
import ext.lib.swg.SwgBorderPanel;
import ext.lib.swg.SwgCheckBox;
import ext.lib.swg.SwgComboBox;
import ext.lib.swg.SwgComponentUnit;
import ext.lib.swg.SwgFileChooser;
import ext.lib.swg.SwgFormLayout;
import ext.lib.swg.SwgLabel;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;

public class HswgExportConditionPanel
extends SwgBorderPanel {
    private static final long serialVersionUID = 2430619727334187161L;
    public SwgTextField filePathField = new SwgTextField();
    protected JButton fileChooseButton;
    protected SwgFileChooser fileChooser;
    protected SwgComboBox formatTypeCombo;
    protected SwgComboBox fieldSeparatorCombo;
    protected SwgComboBox lineSeparatorCombo;
    protected SwgComboBox quotationMarkPolicyCombo;
    protected SwgCheckBox headerEnabledCheckBox;
    protected SwgComboBox encodingCombo;
    protected SwgLabel bomLabel;
    protected SwgCheckBox bomCheckBox;
    protected SwgCheckBox codeMapCheckBox;
    protected SwgCheckBox notVisibleCheckBox;
    protected PoiExportCondition exportCondition;
    protected ItemListener itemListener;

    public HswgExportConditionPanel() throws Exception {
        this.fileChooseButton = new JButton(BcWords.getInstance().browse);
        this.fileChooser = new SwgFileChooser();
        this.formatTypeCombo = new SwgComboBox();
        this.fieldSeparatorCombo = new SwgComboBox();
        this.lineSeparatorCombo = new SwgComboBox();
        this.quotationMarkPolicyCombo = new SwgComboBox();
        this.headerEnabledCheckBox = new SwgCheckBox();
        this.encodingCombo = new SwgComboBox();
        this.bomLabel = new SwgLabel(BcWords.getInstance().bom);
        this.bomCheckBox = new SwgCheckBox();
        this.codeMapCheckBox = new SwgCheckBox();
        this.notVisibleCheckBox = new SwgCheckBox();
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                try {
                    HswgExportConditionPanel.this.itemStateChanged2(ev);
                }
                catch (Exception ex) {
                    HswgExportConditionPanel.this.handleException(ex);
                }
            }
        };
        this.formatTypeCombo.addItem(BcWords.getInstance().csv);
        Enum[] enumArray = PoiConstants.FieldSeparator.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PoiConstants.FieldSeparator fieldSeparator = enumArray[n2];
            this.fieldSeparatorCombo.addItem(fieldSeparator.note);
            ++n2;
        }
        this.fieldSeparatorCombo.addItemListener(this.itemListener);
        enumArray = BcStringUtil.LineSeparator.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum lineSeparator = enumArray[n2];
            this.lineSeparatorCombo.addItem(((BcStringUtil.LineSeparator)lineSeparator).note);
            ++n2;
        }
        this.quotationMarkPolicyCombo.addItem(PoiConstants.QuotationMarkPolicy.necessary.note);
        this.quotationMarkPolicyCombo.addItem(PoiConstants.QuotationMarkPolicy.always.note);
        int i = 0;
        while (i < PoiUtil.charsetListDefault.size()) {
            String charsetName = PoiUtil.charsetListDefault.get(i);
            this.encodingCombo.addItem(charsetName);
            ++i;
        }
        this.encodingCombo.addItemListener(this.itemListener);
        this.bomSetting();
        this.fileChooseButton.addActionListener(this.actionListener);
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        SwgFormLayout formLayout = new SwgFormLayout();
        this.centerPanel.setLayout(formLayout);
        this.filePathField.setPreferredSize(SwgUtil.getTextFieldSize(this.getFont(), 100));
        SwgComponentUnit componentUnit = new SwgComponentUnit((Component)new SwgLabel(BcWords.getInstance().destination, 4), this.filePathField, this.fileChooseButton);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(BcWords.getInstance().format, 4), this.formatTypeCombo);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(BcWords.getInstance().fieldSeparator, 4), this.fieldSeparatorCombo);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(BcWords.getInstance().lineSeparator, 4), this.lineSeparatorCombo);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(BcWords.getInstance().quotationMark, 4), this.quotationMarkPolicyCombo);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(PoiWords.getInstance().header_output.toPlain(), 4), this.headerEnabledCheckBox);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(BcWords.getInstance().encoding, 4), this.encodingCombo);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)this.bomLabel, this.bomCheckBox);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(PoiWords.getInstance().constant_conversion.toPlain(), 4), this.codeMapCheckBox);
        formLayout.componentUnitList.add(componentUnit);
        componentUnit = new SwgComponentUnit((Component)new SwgLabel(PoiWords.getInstance().invisible_column_output.toPlain(), 4), this.notVisibleCheckBox);
        formLayout.componentUnitList.add(componentUnit);
    }

    public void setExportCondition(PoiExportCondition exportCondition) throws Exception {
        this.exportCondition = exportCondition;
        this.fieldSeparatorCombo.setSelectedItem(PoiConstants.FieldSeparator.getNoteBySeparator(exportCondition.fieldSeparator));
        this.lineSeparatorCombo.setSelectedItem(BcStringUtil.LineSeparator.getNoteBySeparator(exportCondition.lineSeparator));
        if (exportCondition.quotationMarkPolicy == PoiConstants.QuotationMarkPolicy.always) {
            this.quotationMarkPolicyCombo.setSelectedIndex(1);
        } else {
            this.quotationMarkPolicyCombo.setSelectedIndex(0);
        }
        this.headerEnabledCheckBox.setSelected(exportCondition.headerEnabled);
        if (!BcStringUtil.isEmpty(exportCondition.encoding)) {
            this.encodingCombo.setSelectedItem(exportCondition.encoding);
        }
        this.bomCheckBox.setSelected(exportCondition.bomEnabled);
        this.codeMapCheckBox.setSelected(exportCondition.codeMapEnabled);
        this.notVisibleCheckBox.setSelected(exportCondition.notVisibleEnabled);
    }

    public PoiExportCondition getExportCondition() throws Exception {
        this.exportCondition.fieldSeparator = PoiConstants.FieldSeparator.getSeparatorByNote(this.fieldSeparatorCombo.getSelectedItem().toString());
        this.exportCondition.lineSeparator = BcStringUtil.LineSeparator.getSeparatorByNote(this.lineSeparatorCombo.getSelectedItem().toString());
        switch (this.quotationMarkPolicyCombo.getSelectedIndex()) {
            case 1: {
                this.exportCondition.quotationMarkPolicy = PoiConstants.QuotationMarkPolicy.always;
                break;
            }
            default: {
                this.exportCondition.quotationMarkPolicy = PoiConstants.QuotationMarkPolicy.necessary;
            }
        }
        this.exportCondition.headerEnabled = this.headerEnabledCheckBox.isSelected();
        this.exportCondition.encoding = this.encodingCombo.getSelectedItem().toString();
        this.exportCondition.bomEnabled = this.bomCheckBox.isSelected();
        this.exportCondition.codeMapEnabled = this.codeMapCheckBox.isSelected();
        this.exportCondition.notVisibleEnabled = this.notVisibleCheckBox.isSelected();
        this.exportCondition.locale = Locale.getDefault();
        return this.exportCondition;
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.fileChooseButton) {
            this.fileChooser.resetChoosableFileFilters();
            if (!BcStringUtil.isEmpty(this.filePathField.getText())) {
                this.fileChooser.setSelectedFile(new File(this.filePathField.getText()));
            }
            switch (this.fileChooser.showDialog(this, BcWords.getInstance().select)) {
                case 0: {
                    this.filePathField.setText(this.fileChooser.getSelectedFile().getPath());
                    break;
                }
            }
        }
    }

    public void itemStateChanged2(ItemEvent ev) {
        if (ev.getStateChange() == 1) {
            if (ev.getSource() == this.fieldSeparatorCombo) {
                String extention = null;
                switch (this.fieldSeparatorCombo.getSelectedIndex()) {
                    case 0: {
                        extention = PoiConstants.Extention.csv.name();
                        break;
                    }
                    case 1: {
                        extention = PoiConstants.Extention.tsv.name();
                    }
                }
                if (!BcStringUtil.isEmpty(this.filePathField.getText())) {
                    File file = BcFileUtil.replaceExtention(new File(this.filePathField.getText()), extention);
                    this.filePathField.setText(file.getPath());
                }
            } else if (ev.getSource() == this.encodingCombo) {
                this.bomSetting();
            }
        }
    }

    public void bomSetting() {
        boolean isUtf8 = BcStringUtil.equalsIgnoreCase((String)this.encodingCombo.getSelectedItem(), "UTF-8");
        this.bomCheckBox.setEnabled(isUtf8);
        this.bomLabel.setEnabled(isUtf8);
    }
}

